
// Persistence of Vision Ray Tracer Scene Description File
// File: flight.pov
// Vers: 3
// Desc: A dog-fight between two fighter-2 planes.
// Auth: Anton Delprado


// ==== Standard POV-Ray Includes ====
#include "colors.inc"	// Standard Color definitions
#include "textures.inc"	// Standard Texture definitions

#declare Missile = merge {
   sphere {0,.125
     pigment {color White}
     finish {ambient .5}
   }
   cylinder {0,<-1.25,0,0>,.125
     pigment {color Red}
     finish {ambient .5}
   }
   cone {<-1.25,0,0>,.125,<-1.75,0,0>,-.125
     pigment {color Red}
     finish {ambient 1}
   }
 }

#declare My_Ship = merge {
  //wings
  difference {
    sphere {0,1
      scale <8,.25,2.5>
    }
    plane {x,0}
    pigment {color Bronze}
    finish {reflection .25}
  }
  sphere {0,1
    scale <.1,.25,2.5>
    pigment {color Bronze}
    finish {reflection .25}
  }
  //cockpit etc.
  difference {
    sphere {0,1
      scale <8,.5,1.5>
    }
    plane {x,0}
    plane {y,0}
    box {<5,0,-.9>,<10,5,.9>}
  }
  intersection {
    sphere {0,1
      scale <8,.5,1.5>
    }
    box {<5,0,-.9>,<10,5,.9>}
    finish {reflection .25 specular .8 roughness .02}
  }
  //Missiles
  object {Missile
   translate <3,-.375,1.75>
  }
  object {Missile
   translate <3,-.375,-1.75>
  }
  //Laser turrets
  merge {
    cylinder {<5,0,1.62>,<6.5,0,1.62>,.05}
    cylinder {<5,0,-1.62>,<6.5,0,-1.62>,.05}
    finish {specular .9 roughness .1}
    pigment {color Gray50}
  }
  //After-burners
  difference {
    cylinder {<0,-.45, 1.5>,<1,-.45, 1.5>,.3}
    cylinder {<-10,-.45, 1.5>,<10,-.45, 1.5>,.25}
  }
  difference {
    cylinder {<0,-.45,-1.5>,<1,-.45,-1.5>,.3}
    cylinder {<-10,-.45,-1.5>,<10,-.45,-1.5>,.25}
  }
  sphere {0,.3
    scale <.3,1,1>
    translate <1,-.45,1.5>
  }
  sphere {0,.3
    scale <.3,1,1>
    translate <1,-.45,-1.5>
  }
  sphere { 0, 1
    pigment { color rgbt <1, 1, 1, 1> }
    halo {
      emitting
      cylindrical_mapping
      linear
      turbulence 1.75
      omega .4
      color_map {
        [ 0 color rgbt <1,0,0,1.0> ]
        [ 0.75 color rgbt <1,0.5,0,-0.2> ]
        [ 1 color rgbt <1,.75,0,-1> ]
      }
      samples 3
      frequency 1.2
      rotate <0,0,90>
      translate <clock*20,0,0>
    }
    hollow
    scale <1,.25,.25>
    translate <0,-.45,1.5>
  }
  sphere { 0, 1
    pigment { color rgbt <1, 1, 1, 1> }
    halo {
      emitting
      cylindrical_mapping
      linear
      turbulence 1.75
      omega .4
      color_map {
        [ 0 color rgbt <1,0,0,1.0> ]
        [ 0.75 color rgbt <1,0.5,0,-0.2> ]
        [ 1 color rgbt <1,.75,0,-1> ]
      }
      samples 3
      frequency 1.2
      rotate <0,0,90>
      translate <clock*20,0,0>
    }
    hollow
    scale <1,.25,.25>
    translate <0,-.45,-1.5>
  }

  pigment {color SteelBlue}
  finish {
    specular .75
    roughness .1
    metallic
  }
}

#declare Laser = cylinder { <0,0,0>,<160,0,0>,.5
  pigment { color rgbt <1, 1, 1, 1> }
  halo {
    emitting
    cylindrical_mapping
    linear
    turbulence 1
    color_map {
      [ 0 color rgbt <0, .75, .25,  .5> ]
      [ 1 color rgbt <0, 1, 0, -1.0> ]
    }
    samples 3
    rotate <0,0,90>
    scale <2,.3,.3>
  }
  hollow
  scale .1
}

#declare Mysky = sphere {
  <0,0,0>,0.98
  texture {
    pigment{Blue_Sky3}
    finish {reflection 0.0 diffuse 0.0 ambient 1.0}
  }
}

//*********************************************************************************************
camera {
  location <500,105,500>
  look_at <520,105,520>
}

object {My_Ship
  rotate <-30,0,30>
  translate <515,105,515>
}

object {My_Ship
  rotate <0,0,-2.5>
  translate <500,107,515>
}
object {Laser
  translate <6.5,0,1.62>
  rotate <0,0,-2.5>
  translate <500,107,515>
} 
object {Laser
  translate <6.5,0,-1.62>
  rotate <0,0,-2.5>
  translate <500,107,515>
} 
sphere { 0, 1.5
  pigment { color rgbt <1, 1, 1, 1> }
  halo {
    emitting
    spherical_mapping
    linear
    turbulence 1.5
    color_map {
      [ 0 color rgbt <1, 0.25, 0,  1> ]
      [ 1 color rgbt <1, 1, 0.5, -4> ]
    }
    samples 10
    scale 0.5
    scale 2.1
  }
  hollow
  scale 6.5
  translate <515,105,515>
}

light_source { <-1500, 9000, 500> color White }

fog {color White distance 1550 }

difference {
  sphere { <0,0,0>,1}
  object {Mysky}
  scale <3000,500,3000>
  texture {
    pigment{Blue_Sky3}
    finish {reflection 0.0 diffuse 0.0 ambient 1.0}
  }
  no_shadow
  hollow
}

plane {
     <0,37,0>, 32
     texture {
       pigment {color rgb<0.0,0.1,0.2>}
       normal {bumps 0.5 scale .8}
       finish {phong 1 reflection .5 ambient 0.1 diffuse 0.2}
     }

}

height_field {
     gif "new.ghf"
     scale <1000,100,1000>
     texture {
       pigment {
         image_map {
           gif "new.ghf"
         }
         rotate x*90
         scale <1000,200,1000>
       }
     finish {crand 0.05 reflection 0.1 diffuse 0.7 ambient 0.2}
     }
     smooth
}

triangle{<0,0,0>,<.25,.5,-.25>,<-.35,.5,-.25>
    pigment {color SteelBlue}
  finish {
    specular .75
    roughness .1
    metallic
  }
  translate <513,100,513>
}
triangle{<0,0,0>,<.25,.5,-.25>,<-.35,.5,-.25>
    pigment {color SteelBlue}
  finish {
    specular .75
    roughness .1
    metallic
  }
  rotate 33.12
  translate <515,108,515>
}
triangle{<0,0,0>,<.25,.5,-.25>,<-.35,.5,-.25>
    pigment {color SteelBlue}
  finish {
    specular .75
    roughness .1
    metallic
  }
  rotate 42.84
  translate <510,107,514>
}
triangle{<0,0,0>,<.25,.5,-.25>,<-.35,.5,-.25>
    pigment {color SteelBlue}
  finish {
    specular .75
    roughness .1
    metallic
  }
  rotate 89.91
  translate <510,103,511>
}
triangle{<0,0,0>,<.25,.5,-.25>,<-.35,.5,-.25>
    pigment {color SteelBlue}
  finish {
    specular .75
    roughness .1
    metallic
  }
  rotate 46.71
  translate <513,103,513>
}
triangle{<0,0,0>,<.25,.5,-.25>,<-.35,.5,-.25>
    pigment {color SteelBlue}
  finish {
    specular .75
    roughness .1
    metallic
  }
  rotate 46.71
  translate <518,103,511>
}
triangle{<0,0,0>,<.25,.5,-.25>,<-.35,.5,-.25>
    pigment {color SteelBlue}
  finish {
    specular .75
    roughness .1
    metallic
  }
  rotate 46.71
  translate <519,108,510>
}
